# P.E.E.R. Audit Installation Guide

A simple guide to get P.E.E.R. Audit running on your machine.

---

## Step 1: Download

Download the package for your operating system:

| Your Computer | Download This |
|---------------|---------------|
| Windows | `peer-audit-win-x64.zip` |
| Mac (M1/M2/M3) | `peer-audit-macos-arm64.tar.gz` |
| Mac (Intel) | `peer-audit-macos-x64.tar.gz` |
| Linux | `peer-audit-linux-x64.tar.gz` |

**Not sure which Mac you have?** Click the Apple menu > "About This Mac". If it says "Apple M1/M2/M3", download the ARM version. If it says "Intel", download the Intel version.

---

## Step 2: Extract

### Windows

1. Right-click the downloaded `.zip` file
2. Click "Extract All..."
3. Choose where to extract and click "Extract"
4. Open the extracted folder

### Mac

1. Double-click the downloaded `.tar.gz` file
2. It will automatically extract to a folder
3. Open the extracted folder

### Linux

Open a terminal and run:

```bash
tar -xzf peer-audit-linux-x64.tar.gz
cd peer-audit-linux-x64
```

---

## Step 3: First Run Setup

### Windows

1. Open the extracted folder
2. Double-click `peer-audit-win-x64.exe`
3. If Windows SmartScreen appears, click "More info" then "Run anyway"

### Mac

**Important:** macOS blocks apps from unidentified developers. You need to allow it once.

**Option A: Terminal (Recommended)**

Open Terminal, navigate to the extracted folder, and run:

```bash
cd ~/Downloads/peer-audit-macos-arm64
xattr -cr .
chmod +x peer-audit-macos-arm64
```

**Option B: System Preferences**

1. Try to open the app (it will be blocked)
2. Go to System Preferences > Security & Privacy > General
3. Click "Open Anyway" next to the blocked app message
4. Click "Open" in the confirmation dialog

### Linux

Open a terminal in the extracted folder:

```bash
chmod +x peer-audit-linux-x64
```

---

## Step 4: Activate Your License

Before scanning, you need to activate with your purchase details.

### Windows (Command Prompt)

```cmd
cd path\to\peer-audit-win-x64
peer-audit-win-x64.exe activate --project C:\path\to\your\project
```

### Mac / Linux (Terminal)

```bash
cd /path/to/peer-audit
./peer-audit-macos-arm64 activate --project /path/to/your/project
```

You'll be prompted for:
- **Email:** The email you used to purchase
- **Order ID:** From your purchase confirmation email

---

## Step 5: Scan Your Project

### Windows

```cmd
peer-audit-win-x64.exe scan C:\path\to\your\project
```

### Mac / Linux

```bash
./peer-audit-macos-arm64 scan /path/to/your/project
```

---

## Step 6: Start the Dashboard

The dashboard gives you a visual interface to explore results.

### Windows

```cmd
peer-audit-win-x64.exe dashboard
```

### Mac / Linux

```bash
./peer-audit-macos-arm64 dashboard
```

Then open your browser to: **http://localhost:9000**

---

## Quick Reference

| Command | What It Does |
|---------|--------------|
| `peer-audit --help` | Show all commands |
| `peer-audit activate` | Activate your license |
| `peer-audit scan /path` | Scan a project |
| `peer-audit dashboard` | Start the web dashboard |
| `peer-audit license` | Check license status |
| `peer-audit report --last` | Generate report from last scan |

---

## Troubleshooting

### "Command not found" (Mac/Linux)

Make sure you're in the correct folder and using `./` before the command:

```bash
cd /path/to/peer-audit-folder
./peer-audit-macos-arm64 --help
```

### "Permission denied" (Mac/Linux)

Make the file executable:

```bash
chmod +x peer-audit-macos-arm64
```

### "App is damaged" or "Cannot be opened" (Mac)

Remove the quarantine flag:

```bash
xattr -cr .
```

### "Windows protected your PC" (Windows)

1. Click "More info"
2. Click "Run anyway"

### Dashboard won't load

1. Make sure nothing else is using port 9000
2. Try a different port: `peer-audit dashboard --port 8080`
3. Check the terminal for error messages

### License activation failed

1. Check your email and order ID are correct
2. Make sure you have an internet connection
3. Contact support with your order details

---

## Getting Help

- **Documentation:** https://oynk.co.uk/peer-audit/docs
- **Support:** hello@oynk.co.uk
- **Issues:** https://github.com/oynk/peer-audit/issues

---

## Updating

To update to a new version:

1. Download the new package
2. Extract it (replacing the old folder)
3. Your license and scan history are stored separately and will be preserved

---

That's it! You're ready to scan your projects for digital waste.
